package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aEventos;

/**
 * Ab18a12s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aEventosDaoImpl implements Ab18aEventosDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aEventos> rwMap = new RowMapper<Ab18aEventos>() {
		public Ab18aEventos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aEventos(resultSet.getLong("T12IDEVENTO"),
					resultSet.getDate("T12FECHAACTUALIZACION"),
					resultSet.getDate("T12FECHAPUBLICACION"),
					resultSet.getString("T12CODEXPEDIENTE"),
					resultSet.getString("T12DESCERROR"),
					resultSet.getLong("T07IDTICKET"),
					resultSet.getLong("T11IDESTADO"));
		}
	};

	private RowMapper<Ab18aEventos> rwMapPK = new RowMapper<Ab18aEventos>() {
		public Ab18aEventos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aEventos(resultSet.getLong("T12IDEVENTO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aEventos>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aEventos>>() {
		public JerarquiaDto<Ab18aEventos> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Ab18aEventos ab18a12s00 = new Ab18aEventos(
					resultSet.getLong("T12IDEVENTO"),
					resultSet.getDate("T12FECHAACTUALIZACION"),
					resultSet.getDate("T12FECHAPUBLICACION"),
					resultSet.getString("T12CODEXPEDIENTE"),
					resultSet.getString("T12DESCERROR"),
					resultSet.getLong("T07IDTICKET"),
					resultSet.getLong("T11IDESTADO"));

			JerarquiaDto<Ab18aEventos> jerarquia = new JerarquiaDto<Ab18aEventos>();
			jerarquia.setModel(ab18a12s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @return Ab18a12s00
	 */
	public Ab18aEventos add(Ab18aEventos ab18a12s00) {
		String query = "INSERT INTO AB18A12S00 (T12_ID_EVENTO, T07_ID_TICKET, T11_ID_ESTADO, T12_FECHA_ACTUALIZACION, T12_FECHA_PUBLICACION, T12_COD_EXPEDIENTE, T12_DESC_ERROR) VALUES (?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, ab18a12s00.getT12IdEvento(),
				ab18a12s00.getT07IdTicket(), ab18a12s00.getT11IdEstado(),
				ab18a12s00.getT12FechaActualizacion(),
				ab18a12s00.getT12FechaPublicacion(),
				ab18a12s00.getT12CodExpediente(), ab18a12s00.getT12DescError());
		return ab18a12s00;
	}

	/**
	 * Updates a single row in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @return Ab18a12s00
	 */
	public Ab18aEventos update(Ab18aEventos ab18a12s00) {
		String query = "UPDATE AB18A12S00 SET T07_ID_TICKET=?, T11_ID_ESTADO=?, T12_FECHA_ACTUALIZACION=?, T12_FECHA_PUBLICACION=?, T12_COD_EXPEDIENTE=?, T12_DESC_ERROR=? WHERE T12_ID_EVENTO=?";

		this.jdbcTemplate.update(query, ab18a12s00.getT07IdTicket(),
				ab18a12s00.getT11IdEstado(),
				ab18a12s00.getT12FechaActualizacion(),
				ab18a12s00.getT12FechaPublicacion(),
				ab18a12s00.getT12CodExpediente(), ab18a12s00.getT12DescError(),
				ab18a12s00.getT12IdEvento());
		return ab18a12s00;
	}

	/**
	 * Finds a single row in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @return Ab18a12s00
	 */
	@Transactional(readOnly = true)
	public Ab18aEventos find(Ab18aEventos ab18a12s00) {
		String query = "SELECT t1.T12_ID_EVENTO T12IDEVENTO, t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION, t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION, t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE, t1.T12_DESC_ERROR T12DESCERROR, t2.T07_ID_TICKET AB18A07S00T07IDTICKET, t2.T07_TICKET AB18A07S00T07TICKET, t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION, t3.T11_ID_ESTADO AB18A11S00T11IDESTADO, t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO, t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION FROM AB18A12S00 t1 , AB18A07S00 t2 , AB18A11S00 t3  WHERE t1.T12_ID_EVENTO = ?   AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+)";

		List<Ab18aEventos> ab18a12s00List = this.jdbcTemplate.query(query,
				this.rwMap, ab18a12s00.getT12IdEvento());
		return (Ab18aEventos) DataAccessUtils.uniqueResult(ab18a12s00List);
	}

	/**
	 * Removes a single row in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @return
	 */
	public void remove(Ab18aEventos ab18a12s00) {
		String query = "DELETE FROM AB18A12S00 WHERE T12_ID_EVENTO=?";
		this.jdbcTemplate.update(query, ab18a12s00.getT12IdEvento());
	}

	/**
	 * Finds a list of rows in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a12s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEventos> findAll(Ab18aEventos ab18a12s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		query.append("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a12s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEventos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a12s00 table using like.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a12s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEventos> findAllLike(Ab18aEventos ab18a12s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		query.append("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a12s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEventos>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a12s00 table.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aEventos ab18a12s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A12S00 t1 , AB18A07S00 t2 , AB18A11S00 t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a12s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a12s00 table using like.
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aEventos ab18a12s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a12s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a12s00 selected for rup_table
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a12s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEventos>> reorderSelection(
			Ab18aEventos ab18a12s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a12s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aEventos.class, filterParamList,
				"T12_ID_EVENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aEventos>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a12s00
	 * @param searchParams
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a12s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEventos>> search(Ab18aEventos filterParams,
			Ab18aEventos searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T07_ID_TICKET= t2.T07_ID_TICKET(+) AND t1.T11_ID_ESTADO= t3.T11_ID_ESTADO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aEventos.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T12_ID_EVENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aEventos>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aEventos filterab18a12s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a12s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Ab18aEventos.class,
						query, params, "T12_ID_EVENTO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a12s00 table.
	 * 
	 * @param filterAb18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a12s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aEventos>> findAllLikeJerarquia(
			Ab18aEventos filterAb18a12s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T12_ID_EVENTO T12IDEVENTO,t1.T12_FECHA_ACTUALIZACION T12FECHAACTUALIZACION,t1.T12_FECHA_PUBLICACION T12FECHAPUBLICACION,t1.T12_COD_EXPEDIENTE T12CODEXPEDIENTE,t1.T12_DESC_ERROR T12DESCERROR,t2.T07_ID_TICKET AB18A07S00T07IDTICKET,t2.T07_TICKET AB18A07S00T07TICKET,t2.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t3.T11_ID_ESTADO AB18A11S00T11IDESTADO,t3.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t2.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A12S00");
		from.add("AB18A07S00");
		from.add("AB18A11S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a12s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T12_ID_EVENTO", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aEventos filterAb18a12s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A12S00");
		from.add("AB18A07S00");
		from.add("AB18A11S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a12s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T12_ID_EVENTO", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a12s00
	 *            Ab18a12s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a12s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEventos>> findAllChild(
			Ab18aEventos filterAb18a12s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A12S00 t1 ,AB18A07S00 t2 ,AB18A11S00 t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A12S00");
		from.add("AB18A07S00");
		from.add("AB18A11S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a12s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T12_ID_EVENTO", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aEventos>(this.rwMapPK,
						"T12_ID_EVENTO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a12s00 entity
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aEventos ab18a12s00) {

		StringBuilder where = new StringBuilder(
				Ab18aEventosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a12s00 != null && ab18a12s00.getT12IdEvento() != null) {
			where.append(" AND t1.T12_ID_EVENTO = ?");
			params.add(ab18a12s00.getT12IdEvento());
		}
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07IdTicket() != null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(ab18a12s00.getAb18a07s00().getT07IdTicket());
		// }
		// if (ab18a12s00 != null
		// && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getAb18a03s00() != null
		// && ab18a12s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(ab18a12s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07Ticket() != null) {
		// where.append(" AND t2.T07_TICKET = ?");
		// params.add(ab18a12s00.getAb18a07s00().getT07Ticket());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07FechaPeticion() != null) {
		// where.append(" AND t2.T07_FECHA_PETICION = ?");
		// params.add(ab18a12s00.getAb18a07s00().getT07FechaPeticion());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a11s00() != null
		// && ab18a12s00.getAb18a11s00().getT11IdEstado() != null) {
		// where.append(" AND t3.T11_ID_ESTADO = ?");
		// params.add(ab18a12s00.getAb18a11s00().getT11IdEstado());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a11s00() != null
		// && ab18a12s00.getAb18a11s00().getT11DescEstado() != null) {
		// where.append(" AND t3.T11_DESC_ESTADO = ?");
		// params.add(ab18a12s00.getAb18a11s00().getT11DescEstado());
		// }
		if (ab18a12s00 != null && ab18a12s00.getT12FechaActualizacion() != null) {
			where.append(" AND t1.T12_FECHA_ACTUALIZACION = ?");
			params.add(ab18a12s00.getT12FechaActualizacion());
		}
		if (ab18a12s00 != null && ab18a12s00.getT12FechaPublicacion() != null) {
			where.append(" AND t1.T12_FECHA_PUBLICACION = ?");
			params.add(ab18a12s00.getT12FechaPublicacion());
		}
		if (ab18a12s00 != null && ab18a12s00.getT12CodExpediente() != null) {
			where.append(" AND t1.T12_COD_EXPEDIENTE = ?");
			params.add(ab18a12s00.getT12CodExpediente());
		}
		if (ab18a12s00 != null && ab18a12s00.getT12DescError() != null) {
			where.append(" AND t1.T12_DESC_ERROR = ?");
			params.add(ab18a12s00.getT12DescError());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a12s00 entity
	 * 
	 * @param ab18a12s00
	 *            Ab18a12s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aEventos ab18a12s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aEventosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a12s00 != null && ab18a12s00.getT12IdEvento() != null) {
			where.append(" AND t1.T12_ID_EVENTO = ?");
			params.add(ab18a12s00.getT12IdEvento());
		}
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07IdTicket() != null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(ab18a12s00.getAb18a07s00().getT07IdTicket());
		// }
		// if (ab18a12s00 != null
		// && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getAb18a03s00() != null
		// && ab18a12s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(ab18a12s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07Ticket() != null) {
		// where.append(" AND UPPER(t2.T07_TICKET) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a12s00.getAb18a07s00().getT07Ticket()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a12s00.getAb18a07s00().getT07Ticket()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T07_TICKET IS NOT NULL");
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a07s00() != null
		// && ab18a12s00.getAb18a07s00().getT07FechaPeticion() != null) {
		// where.append(" AND t2.T07_FECHA_PETICION = ?");
		// params.add(ab18a12s00.getAb18a07s00().getT07FechaPeticion());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a11s00() != null
		// && ab18a12s00.getAb18a11s00().getT11IdEstado() != null) {
		// where.append(" AND t3.T11_ID_ESTADO = ?");
		// params.add(ab18a12s00.getAb18a11s00().getT11IdEstado());
		// }
		// if (ab18a12s00 != null && ab18a12s00.getAb18a11s00() != null
		// && ab18a12s00.getAb18a11s00().getT11DescEstado() != null) {
		// where.append(" AND UPPER(t3.T11_DESC_ESTADO) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a12s00.getAb18a11s00().getT11DescEstado()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a12s00.getAb18a11s00().getT11DescEstado()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t3.T11_DESC_ESTADO IS NOT NULL");
		// }
		if (ab18a12s00 != null && ab18a12s00.getT12FechaActualizacion() != null) {
			where.append(" AND t1.T12_FECHA_ACTUALIZACION = ?");
			params.add(ab18a12s00.getT12FechaActualizacion());
		}
		if (ab18a12s00 != null && ab18a12s00.getT12FechaPublicacion() != null) {
			where.append(" AND t1.T12_FECHA_PUBLICACION = ?");
			params.add(ab18a12s00.getT12FechaPublicacion());
		}
		if (ab18a12s00 != null && ab18a12s00.getT12CodExpediente() != null) {
			where.append(" AND UPPER(t1.T12_COD_EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a12s00.getT12CodExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a12s00.getT12CodExpediente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T12_COD_EXPEDIENTE IS NOT NULL");
		}
		if (ab18a12s00 != null && ab18a12s00.getT12DescError() != null) {
			where.append(" AND UPPER(t1.T12_DESC_ERROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a12s00.getT12DescError().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a12s00.getT12DescError().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T12_DESC_ERROR IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
